# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2017-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""


from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sys, os, os.path, sqlite3, shutil, csv, subprocess,  unicodedata

from .boite import boite


class creerbase():

    def select_dossier_base(self):
        base = QFileDialog.getExistingDirectory(self, u"sélectionner un dossier pour la base")##, "//172.31.144.14/dossiers/sig/data/6_CARTOTHEQUE/VD/VEEE/2017_MNEFZH")
        self.lineEdit_base.setText(base)

    def select_dossier_mc(self):
        mc,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp de la zone humide ","C:/Users", '*.shp *.SHP')
        self.lineEdit_mc.setText(mc)

    def select_zc_mc(self):
        zc_mc,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp de la zone contributive","C:/Users",'*.shp *.SHP')
        self.lineEdit_zc_mc.setText(zc_mc)

    def select_rpg(self):
        rpg,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp du rpg","C:/Users",'*.shp *.SHP')
        self.lineEdit_rpg.setText(rpg)

    def select_dossier_bdTopo(self):
        bdtopo = QFileDialog.getExistingDirectory(self, u"sélectionner le dossier 1_DONNEES_LIVRAISON de la BdTopo")##, "//172.31.144.14/dossiers/sig/data/1_REFERENTIELS/VECTEUR_IGN/BDTOPO")
        self.lineEdit_bdTopo.setText(bdtopo)


    def create_base(self):


        ### recuperation des autres parametres
        self.detailsPlainTextEdit_2.clear()
        dossier_base = self.lineEdit_base.text()
        nom_base = self.lineEdit_nom_base.text()

        path_base = os.path.join(dossier_base + '/', nom_base + '.sqlite')

        fichier_mc = self.lineEdit_mc.text()
        fichier_zc_mc = self.lineEdit_zc_mc.text()
        rpg = self.lineEdit_rpg.text()
        bd_topo = self.lineEdit_bdTopo.text()


################### Dernieres verifications avant lancement ###################

        ####### Verification du remplissage des champs #######

        if dossier_base == '':
            boite.boite_rouge(self.toolButton_base, self.lineEdit_base, self.label_base)
            boite.message(self,u"Vous n'avez pas renseigné de dossier pour l'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        if nom_base == '':
            self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
            self.label_nom_base.setStyleSheet('QLabel {color:#FF0000}')
            boite.message(self,u"Vous n'avez pas renseigné de nom pour l'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        if fichier_mc == '':
            boite.boite_rouge(self.toolButton_mc, self.lineEdit_mc, self.label_mc)
            boite.message(self,u"Vous n'avez pas renseigné de zone humide",u"Remplisser le champ avant de relancer").exec_()
            return

        if fichier_zc_mc == '':
            boite.boite_rouge(self.toolButton_zc_mc, self.lineEdit_zc_mc, self.label_zc_mc)
            boite.message(self,u"Vous n'avez pas renseigné de zone contributive",u"Remplisser le champ avant de relancer").exec_()
            return

        if rpg == '':
            boite.boite_rouge(self.toolButton_rpg, self.lineEdit_rpg, self.label_rpg)
            boite.message(self,u"Vous n'avez pas renseigné de RPG",u"Remplisser le champ avant de relancer").exec_()
            return

        if bd_topo == '':
            boite.boite_rouge(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
            boite.message(self,u"Vous n'avez pas renseigné de BD TOPO®",u"Remplisser le champ avant de relancer").exec_()
            return


        ####### Verification de l'existance d'une base du même nom #######

        if nom_base != '':
            a  = os.listdir(dossier_base)
            if nom_base + ".sqlite" in a:
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                self.label_nom_base.setStyleSheet('QLabel {color:#FF0000}')
                boite.message(self, u"la base " + nom_base + u" existe déjà",u"Renommer l'analyse avant de relancer").exec_()
                return


################### Traitements ###################


        ####### Creation de la base et import de la zone contributive #######

        nom_ligne_com = 'ogr2ogr -f SQLite -dsco SPATIALITE=YES %s %s -nln  %s  -a_srs EPSG:2154 -gt unlimited  ' \
                        % (path_base, fichier_zc_mc, 'zc_' + nom_base)
        print (nom_ligne_com)
        try:
            subprocess.run(nom_ligne_com, shell=True)
            a1 = u"création de la base et import de la table zc réussi !"
            details = ''
            details += "\n" + a1
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(10)
        except BaseException as erreur:
            boite.message(self, str(erreur),u"Erreur lors de la création de la base : contacter l'admin").exec_()
            return
            pass

        ####### connexion a la base #######

        conn = sqlite3.dbapi2.connect(path_base)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")

        ####### création de l'index spatial pour zc_mc #######

        try:
            req_sql = "SELECT CreateSpatialIndex('zc_%s','GEOMETRY');" % (nom_base)
            cur.execute(req_sql)
        except BaseException as erreur:
            boite.message(self, str(erreur),
                              u"Erreur  lors de la création de l index spatial pour la zc_mc : contacter l'admin").exec_()
            return
            pass

        ####### import du site #######

        nom_ligne_com = 'ogr2ogr -append %s %s -nln  %s  -a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES' \
                        % (path_base, fichier_mc, nom_base)
        try:
            subprocess.run(nom_ligne_com, shell=True)
            a2 = u"import de la table mc réussi !"
            details = ''
            details += "\n" + a2
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(20)
        except BaseException as erreur:
            boite.message(self, str(erreur),u"Erreur lors de l'import du site : contacter l'admin").exec_()
            return
            pass


        ####### Calcul de l'emprise spatiale du buffer 5 km de la zc #######

        try :
            req_sql = "select" \
                      " st_minx(st_envelope(st_buffer(geometry, 5000))) as xmin," \
                      " st_miny(st_envelope(st_buffer(geometry, 5000))) as ymin," \
                      " st_maxx(st_envelope(st_buffer(geometry, 5000))) as xmax," \
                      " st_maxy(st_envelope(st_buffer(geometry, 5000))) as ymax" \
                      " from  zc_%s" % (nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                xmin = table[0]
                ymin = table[1]
                xmax = table[2]
                ymax = table[3]
        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de la définition de l'étendue : contacter l'admin").exec_()
            return
            pass


        ####### import de toutes les tables de la BdTopo #######

        list_tables = ['BATI_INDIFFERENCIE', 'BATI_INDUSTRIEL', 'BATI_REMARQUABLE', 'TERRAIN_SPORT',
                       'TRONCON_VOIE_FERREE',
                       'ROUTE_PRIMAIRE', 'ROUTE_SECONDAIRE', 'ZONE_VEGETATION',
                       'TRONCON_COURS_EAU', 'LIGNE_ELECTRIQUE', 'POINT_EAU']
        list_tables_v3 = ['BATIMENT', 'TERRAIN_DE_SPORT',
                          'TRONCON_DE_VOIE_FERREE',
                          'TRONCON_DE_ROUTE', 'ZONE_DE_VEGETATION',
                          'TRONCON_HYDROGRAPHIQUE', 'LIGNE_ELECTRIQUE', 'DETAIL_HYDROGRAPHIQUE']
        numero = 20

        ##### Si encodage en UTF-8 ####

        if not self.checkBox.isChecked():

            #### chargement des shp d origine dans la base ####
            for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                for fichier in fichiers:
                    nom_table, extension = os.path.splitext(fichier)
                    nom_table_lower = nom_table.lower()
                    if extension == ".shp" or extension == '.SHP':
                        if nom_table in list_tables or nom_table in list_tables_v3:
                            path = os.path.join(dossier, fichier)
                            table = nom_table_lower
                            print (table)

                            nom_ligne_com = 'ogr2ogr -append %s %s -nln  %s   -a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry -spat %s %s %s %s' \
                                                            % (path_base, path, table, xmin, ymin, xmax, ymax)
                            try:
                                subprocess.run(nom_ligne_com, shell=True)
                                numero = numero + 1
                                self.progressBar.setValue(numero)
                                details = ''
                                a3 = u'import de la table ' + table + u' de la BdTopo réussi !'
                                details += "\n" + a3
                                self.detailsPlainTextEdit_2.appendPlainText(details)
                            except BaseException as erreur:
                                boite.message(self, str(erreur), u" Erreur lors de l'import des tables de la BD TOPO® (ed >= 171) : contacter l'admin").exec_()
                                return
                                pass



        ##### Si encodage en ISO-8859-1 ####

        elif self.checkBox.isChecked():

            #### creation du dossier temporaire d accueil des shp ####

            temp_shp = os.path.join(dossier_base +'/temp_shp')
            try:
                shutil.rmtree(temp_shp)
            except BaseException as erreur:
                pass

            try:
                os.mkdir(temp_shp)
                print (temp_shp)
            except BaseException as erreur:
                boite.message(self, str(erreur), u" Erreur lors de la creation du 1er dossier temporaire d'accueil du shp (import des tables de la BD TOPO® (ed < 171)) : contacter l'admin").exec_()
                return
                pass

            #### copie des shp d origine dans le dossier temporaire ####
            for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                for fichier in fichiers:
                    nom_table, extension = os.path.splitext(fichier)
                    nom_table_lower = nom_table.lower()
                    if extension == ".shp" or extension == '.SHP':
                        if nom_table in list_tables:
                            path = os.path.join(dossier, fichier)
                            table = nom_table_lower
                            path_temp = os.path.join(temp_shp + '/', nom_table + "_temp.SHP")

                            nom_ligne_com = 'ogr2ogr -f "ESRI Shapefile" %s %s  -spat %s %s %s %s ' \
                                                            % (path_temp, path, xmin, ymin, xmax, ymax)

                            try:
                                subprocess.run(nom_ligne_com, shell=True)
                            except BaseException as erreur:
                                boite.message(self, str(erreur),u" Erreur lors de la 1er copie des tables de la BD TOPO® (ed < 171) : contacter l'admin").exec_()
                                return
                                pass


            #### creation du deuxieme dossier temporaire d accueil des shp ####

            temp_shp2 = os.path.join(dossier_base +'/temp_shp2')
            try:
                shutil.rmtree(temp_shp2)
            except:
                pass
            try:
                os.mkdir(temp_shp2)
            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u" Erreur lors de la creation du 2ème dossier temporaire d'accueil du shp (import des tables de la BD TOPO® (ed < 171)) : contacter l'admin").exec_()
                return
                pass

            #### copie des shp du premier dossier temporaire dans le deuxieme dossier temporaire ####
            for dossier, sous_dossiers, fichiers in os.walk(temp_shp):
                for fichier in fichiers:
                    nom_table, extension = os.path.splitext(fichier)
                    nom_table_lower = nom_table.lower()
                    if extension == ".shp" or extension == '.SHP':
                        path = os.path.join(dossier, fichier)
                        table = nom_table_lower
                        nom_table = nom_table.split("_temp")[0]
                        path_temp = os.path.join(temp_shp2 + '/', nom_table + ".SHP")
                        nom_ligne_com = 'ogr2ogr -f "ESRI Shapefile" %s %s  -lco ENCODING=UTF-8 ' \
                                                    % (path_temp, path)
                        try:
                            subprocess.run(nom_ligne_com, shell=True)
                        except BaseException as erreur:
                            boite.message(self, str(erreur),u" Erreur lors de la 2ème copie des tables de la BD TOPO® (ed < 171) : contacter l'admin").exec_()
                            return
                            pass

            #### chargement des shp du deuxieme dossier d accueil dans la base ####
            for dossier, sous_dossiers, fichiers in os.walk(temp_shp2):
                for fichier in fichiers:
                    nom_table, extension = os.path.splitext(fichier)
                    nom_table_lower = nom_table.lower()
                    if extension == ".shp" or extension == '.SHP':
                        if nom_table in list_tables:
                            path = os.path.join(dossier, fichier)
                            table = nom_table_lower
                            nom_ligne_com = 'ogr2ogr -append %s %s -nln  %s   -a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry -spat %s %s %s %s' \
                                                            % (path_base, path, table, xmin, ymin, xmax, ymax)

                            try:
                                subprocess.run(nom_ligne_com, shell=True)
                                numero = numero + 1
                                self.progressBar.setValue(numero)
                                details = ''
                                a3 = u'import de la table ' + table + u' de la BdTopo réussi !'
                                details += "\n" + a3
                                self.detailsPlainTextEdit_2.appendPlainText(details)
                            except BaseException as erreur:
                                boite.message(self, str(erreur),
                                              u"Erreur lors de l import des tables de la BD TOPO® (ed < 171) : contacter l'admin").exec_()
                                return
                                pass


                            numero = numero + 1
                            self.progressBar.setValue(numero)

            #### suppression des 2 dossiers temporaires ###
            shutil.rmtree(temp_shp)
            shutil.rmtree(temp_shp2)

        details = ''
        a3 = u'import des tables de la BdTopo réussi !'
        details += "\n" + a3
        self.detailsPlainTextEdit_2.appendPlainText(details)



        ####### zone tampon du site : zt #######

        try:
            req_sql = "drop table if exists zt_%s;" % (nom_base)
            cur.execute(req_sql)
            req_sql = "create table zt_%s as " \
                      " with b as (with a as (select ogc_fid, st_buffer(GEOMETRY, 50) as GEOMETRY from %s)" \
                      "select a.ogc_fid, st_intersection (a.GEOMETRY, b.GEOMETRY) as GEOMETRY" \
                      " from a, zc_%s as b" \
                      " where st_intersects (a.GEOMETRY, b.GEOMETRY)) " \
                      " select b.ogc_fid as ogc_fid, st_Multi(st_difference (b.GEOMETRY, c.GEOMETRY)) as GEOMETRY " \
                      " from b, %s as c" % (nom_base, nom_base, nom_base, nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zt_%s', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')" % (nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zt_%s', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')" % (nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT CreateSpatialIndex('zt_%s','GEOMETRY');" % (nom_base)
            cur.execute(req_sql)

        except BaseException as erreur :
            boite.message(self, str(erreur),u"Erreur lors de la création de la zone tampon : contacter l'admin").exec_()
            return
            pass

        self.progressBar.setValue(40)
        a4 = u'création de la zone tampon réussie !'
        details = ''
        details += "\n" + a4
        self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### zone paysage du site : zp #######

        try :
            req_sql = "drop table if exists zp_%s;" % (nom_base)
            cur.execute(req_sql)
            req_sql = "create table zp_%s as " \
                      "select ogc_fid, st_Multi(st_buffer(GEOMETRY, 1000)) as GEOMETRY from %s" % (nom_base, nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zp_%s', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')" % (nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zp_%s', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')" % (nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT CreateSpatialIndex('zp_%s','GEOMETRY');" % (nom_base)
            cur.execute(req_sql)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la création de la zone paysage : contacter l'admin").exec_()
            return
            pass

        self.progressBar.setValue(50)
        a5 = u'création de la zone paysage réussie !'
        details = ''
        details += "\n" + a5
        self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### Table emporte-pièces : zone_contributive et paysage #######

        #### Decoupage des tables ####

        if not self.checkBox_2.isChecked():
            liste_patron = ['zp_' + nom_base]
        elif self.checkBox_2.isChecked():
            liste_patron = ['zc_' + nom_base, 'zp_' + nom_base]

        numero = 50

        try :
            req_sql = req_sql = "SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;"
            cur.execute(req_sql)
            tables = cur.fetchall()

            for table in tables:
                t = table[0]
                t_upper = t.upper()
                if t_upper in list_tables or  t_upper in list_tables_v3:
                    for patron in liste_patron:

                        ### découpage des tables de la BdTopo
                        req_sql = "drop table if exists %s_%s;" % (patron, t)
                        cur.execute(req_sql)

                        if t_upper == 'BATIMENT' :
                            req_sql = "create table %s_%s as select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                                      "from %s as a, %s as b " \
                                      "where st_intersects(b.GEOMETRY, a.GEOMETRY) and leger = 'Non';" % (patron, t, t, patron)
                            cur.execute(req_sql)

                        elif t_upper == 'DETAIL_HYDROGRAPHIQUE' :
                            req_sql = "create table %s_%s as select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                                      "from %s as a, %s as b " \
                                      "where st_intersects(b.GEOMETRY, a.GEOMETRY) and (nature = 'Source captée' or nature = 'Fontaine' or nature LIKE '%s') ;" % (patron, t, t, patron, '%Point%')
                            print (req_sql)
                            cur.execute(req_sql)

                        elif t_upper == 'TRONCON_DE_ROUTE' :
                            req_sql = "create table %s_%s as select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                                      "from %s as a, %s as b " \
                                      "where st_intersects(b.GEOMETRY, a.GEOMETRY) and (nature not in ('Sentier','Bac ou liaison maritime', 'Chemin', 'Escalier') ) ;" % (patron, t, t, patron)
                            print (req_sql)
                            cur.execute(req_sql)

                        else :
                            req_sql = "create table %s_%s as select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                                      "from %s as a, %s as b " \
                                      "where st_intersects(b.GEOMETRY, a.GEOMETRY);" % (patron, t, t, patron)
                            cur.execute(req_sql)



                        if  t_upper == 'TRONCON_DE_ROUTE' or t_upper == 'TRONCON_HYDROGRAPHIQUE' \
                                or t_upper == 'TRONCON_DE_VOIE_FERREE'                        \
                                or t_upper == 'ROUTE_PRIMAIRE' or t_upper == 'ROUTE_SECONDAIRE' \
                                or t_upper == 'TRONCON_COURS_EAU' or t_upper == 'LIGNE_ELECTRIQUE' \
                                or t_upper == 'TRONCON_VOIE_FERREE':
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTILINESTRING', 'XY')" % (patron, t)
                            cur.execute(req_sql)
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTILINESTRING', 'XYZ')" % (patron, t)
                            cur.execute(req_sql)
                        elif t_upper == 'POINT_EAU' or t_upper == 'DETAIL_HYDROGRAPHIQUE':
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTIPOINT', 'XY')" % (patron, t)
                            cur.execute(req_sql)
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTIPOINT', 'XYZ')" % (patron, t)
                            cur.execute(req_sql)
                        else:
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')" % (patron, t)
                            cur.execute(req_sql)
                            req_sql = "SELECT RecoverGeometryColumn('%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')" % (patron, t)
                            cur.execute(req_sql)

                        req_sql = "SELECT CreateSpatialIndex('%s_%s','GEOM');" % (patron, t)
                        cur.execute(req_sql)

                        numero = numero + 1
                        self.progressBar.setValue(numero)
                        details = ''
                        a6 = u'découpage de la table ' + t + u' de la BdTopo avec la ' + patron.split('_')[0] + u' réussi !'
                        details += "\n" + a6
                        self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors du découpage des tables de la Bd Top : contacter l'admin").exec_()
            return
            pass


        a7 = u'découpage des tables de la BdTopo réussi !'
        details = ''
        details += "\n" + a7
        self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### Import du RPG #######

        str_rpg = "rpg"
        nom_ligne_com = 'ogr2ogr -append %s %s -nln %s -a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry -spat %s %s %s %s' \
                        % (path_base, rpg, str_rpg, xmin, ymin, xmax, ymax)

        try:
            subprocess.run(nom_ligne_com, shell=True)
        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de l import du RPG : contacter l'admin").exec_()
            return
            pass

        self.progressBar.setValue(90)
        a8 = u'import du RPG réussi !'
        details = ''
        details += "\n" + a8
        self.detailsPlainTextEdit_2.appendPlainText(details)

        ####### Decoupage du RPG suivant la zone contributive #######

        if self.checkBox_2.isChecked():
            try :
                req_sql = "drop table if exists zc_%s_%s;" % (nom_base, str_rpg)
                cur.execute(req_sql)
                req_sql = "create table zc_%s_%s as" \
                          " select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                          "from %s as a, zc_%s as b " \
                          "where st_intersects(b.GEOMETRY, st_makevalid(a.GEOMETRY));" % (nom_base, str_rpg, str_rpg, nom_base)
                cur.execute(req_sql)
                req_sql = "SELECT RecoverGeometryColumn('zc_%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')" % (nom_base, str_rpg)
                cur.execute(req_sql)
                req_sql = "SELECT RecoverGeometryColumn('zc_%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')" % (nom_base, str_rpg)
                cur.execute(req_sql)
                req_sql = "SELECT CreateSpatialIndex('zc_%s_%s','GEOM');" % (nom_base, str_rpg)
                cur.execute(req_sql)

                self.progressBar.setValue(95)
                a9 = u'decoupage du RPG suivant la zone contributive réussi !'
                details = ''
                details += "\n" + a9
                self.detailsPlainTextEdit_2.appendPlainText(details)

            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u"Erreur lors du découpage du RPG avec la zone contributive : contacter l'admin").exec_()
                return
                pass



        ####### Decoupage du rpg suivant la zone paysage #######
        try :
            req_sql = "drop table if exists zp_%s_%s;" % (nom_base, str_rpg)
            cur.execute(req_sql)
            req_sql = "create table zp_%s_%s as" \
                      " select a.*, st_makevalid(st_multi(st_intersection(b.GEOMETRY, a.GEOMETRY))) as GEOM " \
                      "from %s as a, zp_%s as b " \
                      "where st_intersects(b.GEOMETRY, st_makevalid(a.GEOMETRY));" % (nom_base, str_rpg, str_rpg, nom_base)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zp_%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')" % (nom_base, str_rpg)
            cur.execute(req_sql)
            req_sql = "SELECT RecoverGeometryColumn('zp_%s_%s', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')" % (nom_base, str_rpg)
            cur.execute(req_sql)
            req_sql = "SELECT CreateSpatialIndex('zp_%s_%s','GEOM');" % (nom_base, str_rpg)
            cur.execute(req_sql)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors du découpage du RPG avec la zone paysage : contacter l'admin").exec_()
            return
            pass


        if self.checkBox_2.isChecked():
            self.progressBar.setValue(97)
        elif not self.checkBox_2.isChecked():
            self.progressBar.setValue(100)
        a10 = u'decoupage du RPG suivant la zone paysage réussi !'
        details = ''
        details += "\n" + a10
        self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### Creation de la table Bati total #######
                ### pour surface construite : superficie totale des zones bati dans la zone contributive (en ha 3 chiffres après virgule)
                #### Fusionner les 4 tables ensembles : bati_total
                # bati_indifferencie
                # bati_industriel
                # bati_remarquable
                # terrain_sport


        if self.checkBox_2.isChecked():
            if self.checkBox_3.isChecked():
                try :
                    req_sql = "drop table if exists zc_%s_bati_total;" % (nom_base)
                    cur.execute(req_sql)
                    req_sql = "create table zc_%s_bati_total as " \
                              "select ogc_fid,id,GEOM from zc_%s_batiment union " \
                              "select ogc_fid,id,GEOM from zc_%s_terrain_de_sport; " % (nom_base, nom_base,nom_base)
                    print (req_sql)
                    cur.execute(req_sql)
                    req_sql = "SELECT RecoverGeometryColumn('zc_%s_bati_total', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')" % (nom_base)
                    cur.execute(req_sql)
                    req_sql = "SELECT RecoverGeometryColumn('zc_%s_bati_total', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')" % (nom_base)
                    cur.execute(req_sql)

                except BaseException as erreur:
                    boite.message(self, str(erreur),
                                  u"Erreur lors de la création de la table bati total : contacter l'admin").exec_()
                    return
                    pass


                self.progressBar.setValue(100)
                a11 = u'création de la table zone_bati_total réussie !'
                details = ''
                details += "\n" + a11
                self.detailsPlainTextEdit_2.appendPlainText(details)

            else :
                try:
                    req_sql = "drop table if exists zc_%s_bati_total;" % (nom_base)
                    cur.execute(req_sql)
                    req_sql = "create table zc_%s_bati_total as " \
                              "select ogc_fid,id,GEOM from zc_%s_bati_indifferencie union " \
                              "select ogc_fid,id,GEOM from zc_%s_bati_industriel union " \
                              "select ogc_fid,id,GEOM from zc_%s_bati_remarquable union " \
                              "select ogc_fid,id,GEOM from zc_%s_terrain_sport; " % (
                              nom_base, nom_base, nom_base, nom_base, nom_base)
                    cur.execute(req_sql)
                    req_sql = "SELECT RecoverGeometryColumn('zc_%s_bati_total', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')" % (
                        nom_base)
                    cur.execute(req_sql)
                    req_sql = "SELECT RecoverGeometryColumn('zc_%s_bati_total', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')" % (
                        nom_base)
                    cur.execute(req_sql)

                except BaseException as erreur:
                    boite.message(self, str(erreur),
                                  u"Erreur lors de la création de la table bati total : contacter l'admin").exec_()
                    return
                    pass

                self.progressBar.setValue(100)
                a11 = u'création de la table zone_bati_total réussie !'
                details = ''
                details += "\n" + a11
                self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### Filtre sur les couches BATIMENT, DETAIL_HYDROGRAPHIQUE et TRONCON_DE_ROUTE de la BD TOPO V3 #######
        try:
                req_sql = "delete from batiment where leger = 'Oui';"
                cur.execute(req_sql)
                req_sql = "delete from detail_hydrographique where nature != 'Source captée' and nature != 'Fontaine' and nature NOT LIKE '%s';" % ('%Point')
                cur.execute(req_sql)
                req_sql = "delete from troncon_de_route where nature in ('Sentier','Bac ou liaison maritime', 'Chemin', 'Escalier');"
                cur.execute(req_sql)
                conn.commit()
                conn.close()
        except :
            pass




################### FIN DU PROCESSUS ###################
        msg4 = QMessageBox()
        msg4.setIcon(QMessageBox.Information)
        msg4.setText(u"L'export des données dans la base .sqlite est fini !!")
        msg4.setInformativeText(u"Vous pouvez utiliser la base !!")
        msg4.setWindowTitle(u"Avertissement")
        msg4.exec_()