# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2017-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import re, os.path, unicodedata

from .boite import boite


class gerererreur(boite) :

    def gerer_erreur(self,checked):

        envoyeur = self.sender()  # recuperer le widget emettant le signal

        lien = envoyeur.text()
        lien = unicode(lien)
        lien = unicodedata.normalize('NFKD', lien).encode('ascii', 'ignore')

        nom_rectifie = envoyeur.text()
        nom_rectifie = nom_rectifie.replace(' ', '_')
        nom_rectifie = nom_rectifie.lower()
        nom_rectifie = nom_rectifie.encode('utf8', 'replace')
        nom_rectifie = nom_rectifie.decode('utf8', 'replace')
        nom_rectifie = unicodedata.normalize('NFD', nom_rectifie).encode('ascii', 'ignore')
        nom_rectifie = nom_rectifie.decode('utf8', 'replace')

################### controle de la fenetre Rechercher une couche ###################
        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base_4',self.toolButton_base_4,self.lineEdit_base_4,self.label_base_4)


################### controle de la fenetre Afficher le projet ###################
        ####### controle du chemin du projet #######
        boite.controle_chemin(self,'lineEdit_lien_projet',self.toolButton_lien_projet,self.lineEdit_lien_projet,self.label_lien_projet)


################### controle de la fenetre Creer le projet ###################
        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base_3',self.toolButton_base_3,self.lineEdit_base_3,self.label_base_3)

        ####### controle du chemin du projet #######
        boite.controle_chemin(self,'lineEdit_projet',self.toolButton_projet,self.lineEdit_projet,self.label_projet)

        ####### controle du nom du projet  #######

        if envoyeur.objectName() == 'lineEdit_nomprojet':
            if envoyeur.text() != "":
                self.lineEdit_nomprojet.setStyleSheet('QLineEdit {border: 2px solid #a5d50c}')
                self.label_nomprojet.setStyleSheet('QLabel {color:#a5d50c}')

                #### Verification du nom de la base : espace remplace par _, caracteres speciaux supprimes, majuscules supprimees ####
                self.lineEdit_nomprojet.setText(nom_rectifie)

                #### Verification du nom de la base : ne doit pas commencer par un chiffre ####
                try :
                    var = int(nom_rectifie[0])
                    self.lineEdit_nomprojet.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                    self.label_nomprojet.setStyleSheet('QLabel {color:#FF0000}')
                    boite.message(self,u"Le nom du projet ne doit pas commencer par un chiffre",u"Renommer le projet avant de relancer").exec_()
                    self.lineEdit_nomprojet.clear()
                except  :
                    return

            if envoyeur.text() == "":
                self.lineEdit_nomprojet.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                self.label_nomprojet.setStyleSheet('QLabel {color :#FF0000}')



################### controle de la fenetre Afficher les questions ###################
        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base_2',self.toolButton_base_2,self.lineEdit_base_2,self.label_base_2)



################### controle de la fenetre Creer une base  ###################

        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base',self.toolButton_base,self.lineEdit_base,self.label_base)

        ####### controle du nom de la base #######

        if envoyeur.objectName() == 'lineEdit_nom_base':
            if envoyeur.text() != "":
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #a5d50c}')
                self.label_nom_base.setStyleSheet('QLabel {color:#a5d50c}')

                #### Verification du nom de la base : espace remplace par _, caracteres speciaux supprimes, majuscules supprimees ####
                self.lineEdit_nom_base.setText(nom_rectifie)

                #### Verification du nom de la base : ne doit pas commencer par un chiffre ####
                try :
                    var = int(nom_rectifie[0])
                    self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                    self.label_nom_base.setStyleSheet('QLabel {color:#FF0000}')
                    boite.message(self,u"Le nom de la base ne doit pas commencer par un chiffre",u"Renommer l'analyse avant de relancer").exec_()
                    self.lineEdit_nom_base.clear()
                except  :
                    return

            if envoyeur.text() == "":
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                self.label_nom_base.setStyleSheet('QLabel {color :#FF0000}')


        ####### controle de la zone humide #######
        boite.controle_chemin(self,'lineEdit_mc',self.toolButton_mc,self.lineEdit_mc,self.label_mc)

        if envoyeur.objectName() == 'lineEdit_mc':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_mc, self.lineEdit_mc, self.label_mc)
                    boite.message(self,u"Le nom de la zone humide commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_mc.clear()
                    return

                #### Verification de la geometrie de la zone humide (1 seule entite acceptee) ####
                fichier_mc = self.lineEdit_mc.text()
                layer = QgsVectorLayer(fichier_mc, "test", "ogr")
                feats_count = layer.featureCount()
                if feats_count > 1:
                    boite.boite_rouge(self.toolButton_mc, self.lineEdit_mc, self.label_mc)
                    boite.message(self,u"La couche de la zone humide a " + str(feats_count) + u" entités. Elle ne doit en avoir qu'une seule",u"Modifier la couche avant de relancer").exec_()
                    self.lineEdit_mc.clear()


        ####### controle de la zone contributive #######

        boite.controle_chemin(self, 'lineEdit_zc_mc', self.toolButton_zc_mc, self.lineEdit_zc_mc, self.label_zc_mc)

        if envoyeur.objectName() == 'lineEdit_zc_mc':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_zc_mc, self.lineEdit_zc_mc, self.label_zc_mc)
                    boite.message(self,u"Le nom de la zone contributive commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_zc_mc.clear()
                    return

                #### Verification de la geometrie de la zone contributive (1 seule entite acceptee) ####
                fichier_zc_mc = self.lineEdit_zc_mc.text()
                layer = QgsVectorLayer(fichier_zc_mc, "test", "ogr")
                feats_count = layer.featureCount()
                if feats_count > 1:
                    boite.boite_rouge(self.toolButton_zc_mc, self.lineEdit_zc_mc, self.label_zc_mc)
                    boite.message(self,u"La couche de la zone contributive a " + str(feats_count) + u" entités. Elle ne doit en avoir qu'une seule",u"Modifier la couche avant de relancer").exec_()
                    self.lineEdit_zc_mc.clear()


        ####### controle du RPG #######

        boite.controle_chemin(self, 'lineEdit_rpg', self.toolButton_rpg, self.lineEdit_rpg, self.label_rpg)

        if envoyeur.objectName() == 'lineEdit_rpg':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_rpg, self.lineEdit_rpg, self.label_rpg)
                    boite.message(self,u"Le nom du RPG commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_rpg.clear()
                    return

                #### Verification de l existence du champ CULT_MAJ or CODE_GROUP  ####
                liste_champs=[]
                layer = QgsVectorLayer(envoyeur.text(), "layer_name_you_like", "ogr")
                for field in layer.fields():
                    liste_champs.append(field.name())
                if "CULT_MAJ" in liste_champs or "CODE_GROUP" in liste_champs  :
                    boite.boite_verte(self.toolButton_rpg, self.lineEdit_rpg, self.label_rpg)
                else :
                    boite.boite_rouge(self.toolButton_rpg, self.lineEdit_rpg, self.label_rpg)
                    boite.message(self,u"Le RPG doit contenir une colonne nommée CULT_MAJ ou CODE-GROUP et contenant le code de la culture majoritaire",u"Modifier le .shp avant de relancer").exec_()
                    self.lineEdit_rpg.clear()
                    return


        ####### controle de la BdTopo #######

        if self.checkBox_3.isChecked():

            bd_topo = self.lineEdit_bdTopo.text()
            list_tables_v3 = ['BATIMENT', 'TERRAIN_DE_SPORT',
                           'TRONCON_DE_VOIE_FERREE',
                           'TRONCON_DE_ROUTE', 'ZONE_DE_VEGETATION',
                           'TRONCON_HYDROGRAPHIQUE', 'LIGNE_ELECTRIQUE', 'DETAIL_HYDROGRAPHIQUE']
            list_tables_v2 = ['BATI_INDIFFERENCIE', 'BATI_INDUSTRIEL', 'BATI_REMARQUABLE', 'TERRAIN_SPORT',
                           'TRONCON_VOIE_FERREE',
                           'ROUTE_PRIMAIRE', 'ROUTE_SECONDAIRE', 'ZONE_VEGETATION',
                           'TRONCON_COURS_EAU', 'LIGNE_ELECTRIQUE', 'POINT_EAU']
            list_tables_user = []

            boite.controle_chemin(self, 'lineEdit_bdTopo', self.toolButton_bdTopo, self.lineEdit_bdTopo,
                                  self.label_bdTopo)

            if envoyeur.objectName() == 'lineEdit_bdTopo':
                if envoyeur.text() != "":
                    boite.boite_verte(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                    self.checkBox_3.setStyleSheet('QCheckBox {color: #a5d50c}')

                    #### Verification de la presence de toutes les tables attendues dans la bdTopo selectionnee ####

                    for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                        for fichier in fichiers:
                            nom_table, extension = os.path.splitext(fichier)
                            if extension == ".shp" or extension == '.SHP':
                                list_tables_user.append(nom_table)
                    a = list(set(list_tables_v3) & set(list_tables_user))
                    list_tables_v3.sort()
                    a.sort()
                    b = set(list_tables_v3) - set(a)
                    print(len(b))

                    a2 = list(set(list_tables_v2) & set(list_tables_user))
                    list_tables_v2.sort()
                    a2.sort()
                    b2 = set(list_tables_v2) - set(a2)
                    print(len(b2))

                    if len(b) > 0 and len(b2) > 0:
                        boite.boite_rouge(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                        couches_manquante = ((str(tuple(list(b)))).replace('(', '')).replace(')', '')
                        boite.message(self,
                                      u"Il manque les couches " + couches_manquante + u" dans la BD TOPO® que vous avez choisie",
                                      u"Ajoutez les avant de relancer ou VERIFIER la VERSION de la BD TOPO®").exec_()
                        self.lineEdit_bdTopo.clear()
                        return

                    elif len(b) > 0 and len(b2) == 0:
                        boite.boite_rouge(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                        self.checkBox_3.setStyleSheet('QCheckBox {color: #FF0000}')
                        boite.message(self,
                                          u"Il semblerais que la version de la BD TOPO® utilisée ne soit pas la v3 ",
                                          u"VERIFIER la VERSION de la BD TOPO® et décocher la case précédente si besoin").exec_()
                        return

                        #### Verification de l'encodage ####

                    for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                        for fichier in fichiers:
                            nom_table, extension = os.path.splitext(fichier)
                            if nom_table == 'TRONCON_DE_ROUTE':
                                if extension == ".cpg" or extension == '.CPG':
                                    self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                    temp_shp = os.path.join(dossier, fichier)
                                    with open(temp_shp, "r") as fichier:
                                        fichier_entier = fichier.read()
                                        files = fichier_entier.split("\n")
                                        if 'UTF-8' in files:
                                            if self.checkBox.isChecked():
                                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                                boite.message(self,
                                                                  u'La BD TOPO® choisie semble être encodée en UTF8',
                                                                  u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                                return
                                            else:
                                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                                return
                                        else:
                                            if self.checkBox.isChecked():
                                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                            else:
                                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                                boite.message(self,
                                                                  u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                                  u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                                return

                                else:
                                    if extension == ".shp" or extension == '.SHP':
                                        self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                        if self.checkBox.isChecked():
                                            self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                            return
                                        else:
                                            self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                            boite.message(self,
                                                              u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()

                                            return
                    return

        else :

            bd_topo = self.lineEdit_bdTopo.text()
            list_tables_v2 = ['BATI_INDIFFERENCIE', 'BATI_INDUSTRIEL', 'BATI_REMARQUABLE', 'TERRAIN_SPORT',
                           'TRONCON_VOIE_FERREE',
                           'ROUTE_PRIMAIRE', 'ROUTE_SECONDAIRE', 'ZONE_VEGETATION',
                           'TRONCON_COURS_EAU', 'LIGNE_ELECTRIQUE', 'POINT_EAU']

            list_tables_v3 = ['BATIMENT', 'TERRAIN_DE_SPORT',
                           'TRONCON_DE_VOIE_FERREE',
                           'TRONCON_DE_ROUTE', 'ZONE_DE_VEGETATION',
                           'TRONCON_HYDROGRAPHIQUE', 'LIGNE_ELECTRIQUE', 'DETAIL_HYDROGRAPHIQUE']
            list_tables_user = []

            boite.controle_chemin(self, 'lineEdit_bdTopo', self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)

            if envoyeur.objectName() == 'lineEdit_bdTopo':
                if envoyeur.text() != "":
                    boite.boite_verte(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                    self.checkBox_3.setStyleSheet('QCheckBox {color: #a5d50c}')

                    #### Verification de la presence de toutes les tables attendues dans la bdTopo selectionnee ####

                    for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                        for fichier in fichiers:
                            nom_table, extension = os.path.splitext(fichier)
                            if extension == ".shp" or extension == '.SHP':
                                list_tables_user.append(nom_table)
                    a = list(set(list_tables_v3) & set(list_tables_user))
                    list_tables_v3.sort()
                    a.sort()
                    b = set(list_tables_v3) - set(a)
                    print(len(b))

                    a2 = list(set(list_tables_v2) & set(list_tables_user))
                    list_tables_v2.sort()
                    a2.sort()
                    b2 = set(list_tables_v2) - set(a2)
                    print (len(b2))

                    if len(b2) > 0 and len(b) > 0:
                        boite.boite_rouge(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                        couches_manquante = ((str(tuple(list(b)))).replace('(', '')).replace(')', '')
                        boite.message(self,u"Il manque les couches " + couches_manquante + u" dans la BD TOPO® que vous avez choisie",
                                      u"Ajoutez les avant de relancer ou VERIFIER la VERSION de la BD TOPO®").exec_()
                        self.lineEdit_bdTopo.clear()
                        return

                    elif len(b2) > 0 and len(b) == 0:
                        boite.boite_rouge(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                        self.checkBox_3.setStyleSheet('QCheckBox {color: #FF0000}')
                        boite.message(self,
                                      u"Il semblerais que la version de la BD TOPO® utilisée soit la v3 ",
                                      u"VERIFIER la VERSION de la BD TOPO® et cocher la case précédente si besoin").exec_()
                        return

                    #### Verification de l'encodage ####

                    for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                        for fichier in fichiers:
                            nom_table, extension = os.path.splitext(fichier)
                            if nom_table ==  'ROUTE_PRIMAIRE':
                                if extension == ".cpg" or extension == '.CPG':
                                    self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                    temp_shp = os.path.join(dossier, fichier)
                                    with open(temp_shp, "r") as fichier:
                                        fichier_entier = fichier.read()
                                        files = fichier_entier.split("\n")
                                        if 'UTF-8' in files:
                                            if self.checkBox.isChecked():
                                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                                boite.message(self,u'La BD TOPO® choisie semble être encodée en UTF8',u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                                return
                                            else :
                                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                                return
                                        else :
                                            if self.checkBox.isChecked():
                                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                            else :
                                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                                boite.message(self,u'La BD TOPO® choisie semble être encodée en ISO-88591',u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                                return

                                else :
                                    if extension == ".shp" or extension == '.SHP':
                                        self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                        if self.checkBox.isChecked():
                                            self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                            return
                                        else :
                                            self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                            boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                          u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()

                                            return
                    return

        ####### Verification du choix de la V3 de la BdTopo (case a cocher) #######

        if envoyeur.objectName() == 'checkBox_3':

            #### V3, case cochee ####

            if checked :


                        bd_topo = self.lineEdit_bdTopo.text()
                        if bd_topo != '':
                            list_tables = ['BATIMENT', 'TERRAIN_DE_SPORT',
                                           'TRONCON_DE_VOIE_FERREE',
                                           'TRONCON_DE_ROUTE', 'ZONE_DE_VEGETATION',
                                           'TRONCON_HYDROGRAPHIQUE', 'LIGNE_ELECTRIQUE', 'DETAIL_HYDROGRAPHIQUE']
                            list_tables_user = []

                            for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                                for fichier in fichiers:
                                    nom_table, extension = os.path.splitext(fichier)
                                    if extension == ".shp" or extension == '.SHP':
                                        list_tables_user.append(nom_table)
                            a = list(set(list_tables) & set(list_tables_user))
                            list_tables.sort()
                            a.sort()
                            b = set(list_tables) - set(a)
                            print(len(b))
                            if len(b) == 0:
                                boite.boite_verte(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                                self.checkBox_3.setStyleSheet('QCheckBox {color: #a5d50c}')
                                return
                            else :
                                self.checkBox_3.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self,
                                              u"la version de la BD TOPO® ne semble pas être la V3",
                                              u"Vérifier la version de la BD TOPO®").exec_()



            #### < V3, case non cochee ####

            else :

                        bd_topo = self.lineEdit_bdTopo.text()
                        if bd_topo != '':

                            list_tables = ['BATI_INDIFFERENCIE', 'BATI_INDUSTRIEL', 'BATI_REMARQUABLE', 'TERRAIN_SPORT',
                                           'TRONCON_VOIE_FERREE',
                                           'ROUTE_PRIMAIRE', 'ROUTE_SECONDAIRE', 'ZONE_VEGETATION',
                                           'TRONCON_COURS_EAU', 'LIGNE_ELECTRIQUE', 'POINT_EAU']
                            list_tables_user = []

                            for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                                for fichier in fichiers:
                                    nom_table, extension = os.path.splitext(fichier)
                                    if extension == ".shp" or extension == '.SHP':
                                        list_tables_user.append(nom_table)
                            a = list(set(list_tables) & set(list_tables_user))
                            list_tables.sort()
                            a.sort()
                            b = set(list_tables) - set(a)
                            print(len(b))
                            if len(b) == 0:
                                boite.boite_verte(self.toolButton_bdTopo, self.lineEdit_bdTopo, self.label_bdTopo)
                                self.checkBox_3.setStyleSheet('QCheckBox {color: #a5d50c}')
                                return
                            else :
                                self.checkBox_3.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self,
                                              u"la version de la BD TOPO® semble être la V3",
                                              u"Vérifier la version de la BD TOPO®").exec_()

        ####### Verification du choix de l encodage (case a cocher) #######

        if envoyeur.objectName() == 'checkBox':

            #### UTF-8, case cochee ####

            if checked :

                for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                    for fichier in fichiers:
                        nom_table, extension = os.path.splitext(fichier)
                        if nom_table ==  'ROUTE_PRIMAIRE' or nom_table ==  'TRONCON_DE_ROUTE':
                            if extension == ".cpg" or extension == '.CPG':
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                temp_shp = os.path.join(dossier, fichier)
                                with open(temp_shp, "r") as fichier:
                                    fichier_entier = fichier.read()
                                    files = fichier_entier.split("\n")
                                    if 'UTF-8' in files:
                                        self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                        boite.message(self, u'La BD TOPO® choisie semble être encodée en UTF8',
                                                      u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                        return
                                    else :
                                        self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                        return
                            else :
                                if extension == ".shp" or extension == '.SHP':
                                    self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')

            #### ISO-8859-1, case non cochee ####

            else :

                for dossier, sous_dossiers, fichiers in os.walk(bd_topo):
                    for fichier in fichiers:
                        nom_table, extension = os.path.splitext(fichier)
                        if nom_table == 'ROUTE_PRIMAIRE' or nom_table ==  'TRONCON_DE_ROUTE':
                            if extension == ".cpg" or extension == '.CPG':
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                temp_shp = os.path.join(dossier, fichier)
                                with open(temp_shp, "r") as fichier:
                                    fichier_entier = fichier.read()
                                    files = fichier_entier.split("\n")
                                    if 'UTF-8' in files:
                                        self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                        return
                                    else:
                                        self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                        boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                      u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                        return
                            else:
                                if extension == ".shp" or extension == '.SHP':
                                    self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                    boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                  u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                    return


