# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2017-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""

from PyQt5 import QtCore
from PyQt5.QtGui import QIcon, QPixmap
from PyQt5.QtWidgets import QDialog, QMessageBox

import os.path


from .gc_utils import (load_ui)
from .Mnefzh_dialog import MNEFZHDialog
from .couches import rechercherunecouche
from .questions import afficherquestions
from .projet import creerprojet, afficherprojet
from .creationbase import creerbase
from .internet import ouvririnternet
from .gestionerreurs import gerererreur
from .boite import boite


pluginPath = os.path.dirname(__file__)
FORM_CLASS = load_ui('Mnefzh_dialog_base')


class appelfonction(QDialog,QPixmap, FORM_CLASS, rechercherunecouche,afficherquestions,afficherprojet,creerprojet,creerbase,ouvririnternet, gerererreur):

    def __init__(self, iface, parent=None):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.iface = iface


        self.tabWidget.setStyleSheet( "QTabBar:tab {color: #464749; background-color: #E6E7E8;} "
                                      "QTabBar:tab:selected {color: #EE7F00 ;background-color: white} QTabBar:tab:hover {color: #EE7F00 ;background-color: white}"
                                      "QPushButton {color : #EE7F00 ; background-color : white;  "
                                      "border-style: solid; border-width: 2px; border-color: #EE7F00 ; font: bold 10px;min-width: 4em; padding: 2.5px;}"
                                      "QPushButton:hover {color : white; background-color : #EE7F00 ;}"
                                      "QToolButton {color : #EE7F00 ; background-color : white; "
                                                "border-style: solid; border-width: 1px; border-color: #EE7F00 ; font: bold 9px;min-width: 1em; padding: 1px;}"
                                               "QToolButton:hover {color : white; background-color : #EE7F00 ;}"
                                      "QTabWidget {background-color: white;border-color: white}"
                                      "QLabel {color : #464749;}"
                                      "QTextBrowser {color : #464749;}"
                                      "QListWidget:item {color : #464749;}"
                                      "QListWidget:item:hover {color : #464749;background-color:  #FDC99B;}"
                                      "QListWidget:item:selected {color : #FDC99B;background-color: white;}"
                                      "QDoubleSpinBox:up-button:hover {background-color : #EE7F00 ;}"
                                      "QDoubleSpinBox:down-button:hover {background-color : #EE7F00 ;}"
                                      "QDoubleSpinBox{colors : #464749; border-style: solid; border-width: 1px; border-color: #464749 ;min-width: 5em; padding: 2px;}"
                                      )


####### affichage des icones des partenaires #######
        #### Cerema ####
        self.pushButton.setStyleSheet("qproperty-icon: url(:/plugins/Mnefzh/icones/Cerema.png)")
        self.pushButton.setIconSize(QtCore.QSize(150, 50))
        #### AFB ####
        self.pushButton_2.setStyleSheet("qproperty-icon: url(:/plugins/Mnefzh/icones/Afb.png)")
        self.pushButton_2.setIconSize(QtCore.QSize(200, 60))
        #### UMS ####
        self.pushButton_3.setStyleSheet("qproperty-icon: url(:/plugins/Mnefzh/icones/Ums.png)")
        self.pushButton_3.setIconSize(QtCore.QSize(200, 110))

####### parametres de la fenetre d affichage des questions #######
        self.webView.setStyleSheet('QWebView {background-color: #f0f0f0;}')

####### parametres de la photo de la page d accueil de l extension  #######
        path_photo = os.path.join(os.path.dirname(__file__), 'icones', 'Couverture.png')
        self.label.setPixmap(QPixmap (path_photo))

####### affichage et lien vers le guide et le manuel d utilisation #######

        #### lien vers le manuel d utilisation
        path_manuel = os.path.join(os.path.dirname(__file__), 'doc', 'Manuel_Utilisation_MNEFZH.pdf')
        path_manuel = path_manuel.replace('\\', '/')

        #### affichage du guide et du manuel d utilisation ####
        guide = u"<a href=""http://www.onema.fr/node/3981"">le guide </a>" + u"de la méthode nationale d'évaluation des fonctions des zones humides"
        aide= "<br /> <br />"u"<a href=path_manuel>l'aide </a>" + u"pour l'utilisation de l'outil MNEFZH"
        aide = aide.replace("path_manuel", path_manuel)
        guide += aide
        self.label_guide.setText(guide)
        self.label_guide.setOpenExternalLinks(True)


####### Ouvrir les sites a partir des icones #######

        self.pushButton.clicked.connect(self.ouvrir_ceremaweb)
        self.pushButton_2.clicked.connect(self.ouvrir_afb)
        self.pushButton_3.clicked.connect(self.ouvrir_ums)


####### Creer base #######

        #### selection des dossiers et fichiers ####
        self.toolButton_base.clicked.connect(self.select_dossier_base)
        self.toolButton_mc.clicked.connect(self.select_dossier_mc)
        self.toolButton_zc_mc.clicked.connect(self.select_zc_mc)
        self.toolButton_rpg.clicked.connect(self.select_rpg)
        self.toolButton_bdTopo.clicked.connect(self.select_dossier_bdTopo)

        #### creation de la base ####
        self.pushButton_save_base.clicked.connect(self.create_base)

        #### verification des erreurs ####
        self.lineEdit_base.textChanged.connect(self.gerer_erreur)
        self.lineEdit_nom_base.textChanged.connect(self.gerer_erreur)
        self.lineEdit_mc.textChanged.connect(self.gerer_erreur)
        self.lineEdit_zc_mc.textChanged.connect(self.gerer_erreur)
        self.lineEdit_rpg.textChanged.connect(self.gerer_erreur)
        self.lineEdit_bdTopo.textChanged.connect(self.gerer_erreur)
        self.checkBox.stateChanged.connect(self.gerer_erreur)
        self.checkBox_2.stateChanged.connect(self.gerer_erreur)
        self.checkBox_3.stateChanged.connect(self.gerer_erreur)


        #### mise a zero de la barre de progression ####
        self.progressBar.setMinimum(0)
        self.progressBar.setMaximum(100)
        self.progressBar.setValue(0)


####### Afficher les questions #######

        #### selection des dosssier et fichiers ####
        self.toolButton_base_2.clicked.connect(self.select_dossier_base_2)

        #### affichage des questions ####
        self.pushButton_questions.clicked.connect(self.affiche_questions)

        #### verification des erreurs ####
        self.lineEdit_base_2.textChanged.connect(self.gerer_erreur)


####### Afficher projet #######

        #### selection des dosssier et fichiers ####
        self.toolButton_lien_projet.clicked.connect(self.select_lien_projet)

        #### affichage du projet ####
        self.pushButton_afficher_projet.clicked.connect(self.afficher_projet)

        #### verification des erreurs ####
        self.lineEdit_lien_projet.textChanged.connect(self.gerer_erreur)


### Creer projet

        #### selection des dosssier et fichiers ####
        self.toolButton_base_3.clicked.connect(self.select_dossier_base_3)
        self.toolButton_projet.clicked.connect(self.select_dossier_projet)

        #### creation du projet ####
        self.pushButton_creer_projet.clicked.connect(self.creer_projet)

        #### verification des erreurs ####
        self.lineEdit_base_3.textChanged.connect(self.gerer_erreur)
        self.lineEdit_projet.textChanged.connect(self.gerer_erreur)
        self.lineEdit_nomprojet.textChanged.connect(self.gerer_erreur)


###Rechercher et afficher les couches

        #### selection des dosssier et fichiers ####
        self.toolButton_base_4.clicked.connect(self.select_dossier_base_4)

        #### recherche des couches ####
        self.pushButton_nom.clicked.connect(self.recherche_couche_theme)

        #### chargement des couches dans QGIS ####
        self.addSelectedPushButton.clicked.connect(self.affiche_couche)

        #### verification des erreurs ####
        self.lineEdit_base_4.textChanged.connect(self.gerer_erreur)



