# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2017-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import os, sqlite3

from .boite import boite



class afficherprojet():

    def select_lien_projet(self):
        lien_projet,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .qgs du projet souhaité", '*.qgs')
        self.lineEdit_lien_projet.setText(lien_projet)

    def afficher_projet(self):

        #### definition des variables ####

        path_projet = self.lineEdit_lien_projet.text()

        #### Verification du remplissage des champs #######

        if path_projet == '':
            boite.boite_rouge(self.toolButton_lien_projet, self.lineEdit_lien_projet, self.label_lien_projet)
            boite.message(self,u"Vous n'avez pas renseigné de projet",u"Remplisser le champ avant de relancer").exec_()
            return

        #### ouverture du nouveau projet ####

        project = QgsProject.instance()
        projet = project.read(path_projet)


class creerprojet():

    def select_dossier_base_3(self):
        base_3,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .sqlite de la base souhaitée", '*.sqlite')
        self.lineEdit_base_3.setText(base_3)

    def select_dossier_projet(self):
        projet = QFileDialog.getExistingDirectory(self, u"sélectionner un dossier pour le projet")
        self.lineEdit_projet.setText(projet)

    def creer_projet(self):

        #### definition des variables ####

        dossier_base_3 = self.lineEdit_base_3.text()
        lineEdit_projet = self.lineEdit_projet.text()
        lineEdit_nomprojet = self.lineEdit_nomprojet.text()

        table_mc = (dossier_base_3.split('/')[-1]).split('.')[0]
        table_rpg = "zc_" + table_mc + "_rpg"
        table_zc = "zc_" + table_mc
        table_zt = "zt_" + table_mc
        table_zp = "zp_" + table_mc

        #### Verification du remplissage des champs #######

        if dossier_base_3 == '':
            boite.boite_rouge(self.toolButton_base_3, self.lineEdit_base_3, self.label_base_3)
            boite.message(self,u"Vous n'avez pas renseigné d'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        if lineEdit_projet == '':
            boite.boite_rouge(self.toolButton_projet, self.lineEdit_projet, self.label_projet)
            boite.message(self,u"Vous n'avez pas renseigné de dossier pour le projet",u"Remplisser le champ avant de relancer").exec_()
            return

        if lineEdit_nomprojet == '':
            self.lineEdit_nomprojet.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
            self.label_nomprojet.setStyleSheet('QLabel {color:#FF0000}')
            boite.message(self,u"Vous n'avez pas renseigné de nom de projet",u"Remplisser le champ avant de relancer").exec_()
            return

        #### recuperation du lien vers le projet modele ####

        path_modele_projet =os.path.join(os.path.dirname(__file__), 'projet_qgs', 'projet_modele.qgs')

        #### ouverture du projet pour lecture ####

        modele_projet = open(path_modele_projet, "r")

        #### lecture du projet modele et modification des variables attendues dans le projet .qgs ####

        chaine = modele_projet.read()
        modele_projet.close()
        result = chaine.replace("remplacer_chemin_base", dossier_base_3)
        result = result.replace("table_mc", table_mc)
        result = result.replace("table_rpg", table_rpg)
        result = result.replace("table_zc", table_zc)
        result = result.replace("table_zt", table_zt)
        result = result.replace("table_zp", table_zp)

        #### enregistrement de l etendue du projet ####

        try :
            conn = sqlite3.dbapi2.connect(dossier_base_3)
            cur = conn.cursor()
            conn.enable_load_extension(True)
            conn.execute("SELECT load_extension('mod_spatialite')")

            #### recuperation de l etendue ####

            req_sql = "select" \
                      " st_minx(st_envelope(st_buffer(geometry, 1000))) as xmin," \
                      " st_miny(st_envelope(st_buffer(geometry, 1000))) as ymin," \
                      " st_maxx(st_envelope(st_buffer(geometry, 1000))) as xmax," \
                      " st_maxy(st_envelope(st_buffer(geometry, 1000))) as ymax" \
                      " from  zc_{}".format(table_mc)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                etendueminx = str(table[0])
                etendueminy = str(table[1])
                etenduemaxx = str(table[2])
                etenduemaxy = str(table[3])
        except BaseException as erreur:
            boite.message(self,str(erreur),u"Erreur lors de la définition de l étendue : contacter l'admin").exec_()
            pass

        #### modification de l etendue dans le fichier projet .qgs ####

        result = result.replace("etendueminx", etendueminx)
        result = result.replace("etendueminy", etendueminy)
        result = result.replace("etenduemaxx", etenduemaxx)
        result = result.replace("etenduemaxy", etenduemaxy)

        #### recuperation du chemin choisi pour l enregistrement du projet ####

        path_projet = os.path.join(lineEdit_projet, lineEdit_nomprojet + '.qgs')

        #### ecriture du nouveau projet ####

        f = open(path_projet, "w")
        f.write(result)
        f.close()

        #### ouverture du nouveau projet ####

        project = QgsProject.instance()
        projet = project.read(path_projet)

