# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2017-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sqlite3

from .boite import boite


class afficherquestions():

    def select_dossier_base_2(self):
        base_2,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .sqlite de la base souhaitée", '*.sqlite')
        self.lineEdit_base_2.setText(base_2)


    def affiche_questions(self):

        self.webView.history().clear()

        #### definition des variables ####
        dossier_base_2 = self.lineEdit_base_2.text()
        nom_base = (dossier_base_2.split('/')[-1]).split('.')[0]

        #### Verification du remplissage des champs #######

        if dossier_base_2 == '':
            boite.boite_rouge(self.toolButton_base_2, self.lineEdit_base_2, self.label_base_2)
            boite.message(self,u"Vous n'avez pas renseigné d'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        #### connexion a la base selectionnee ####

        conn = sqlite3.dbapi2.connect(dossier_base_2)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")

        #### creation de la table des resulats ####

        req_sql = "drop table if exists resultats;"
        cur.execute(req_sql)
        req_sql = "create table resultats (id INT PRIMARY KEY NOT NULL,reponse TEXT, valeur INT4);"
        cur.execute(req_sql)


################### Response aux questions  ###################

        ####### Q1
        ### superficie du site

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from {};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_site = table[0]
            q1 = u"Q1 - superficie du site : " + str(area_site)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (1, '{}', '{}');".format(q1,area_site)
            cur.execute(req_sql)

        ####### Q11
        ### superficie de la zone contributive (zc)

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from zc_%s;" %(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_zc = table[0]
            q11 = u"Q11 - superficie de la zone contributive : " + str(area_zc)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (11, '{}', '{}');".format(q11, area_zc)
            cur.execute(req_sql)

        ###### Q131 Q132 Q133
        ### superficie des surfaces divers, des surfaces enherbees et des surfaces cultivees dans la zone contributive (zc_rpg)

        try :
            liste_cult_maj = ['28','11,12,13,17,18,19','1,2,3,4,5,6,7,8,9,10,14,15,16,20,21,22,23,24,25,26,27']
            for cult_maj in liste_cult_maj :

                try :
                    req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_rpg where cult_maj in ({});".format(nom_base, cult_maj)
                    cur.execute(req_sql)
                except BaseException:
                    req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_rpg where code_group in ({});".format(nom_base, cult_maj)
                    cur.execute(req_sql)
                    pass

                tables = cur.fetchall()
                for table in tables:
                    area_rpg_zc = table[0]
                    if cult_maj == '28':
                        if area_rpg_zc is None:
                            q131 = u"Q131 - superficie divers : aucune superficie divers "
                        else :
                            q131 = u"Q131 - superficie divers : " + str(area_rpg_zc) + u" / ATTENTION :  réaliser une photo-interprétation pour réaffecter ce divers si vous le jugez indispensable ; ce type d assolement n est pas renseigné dans le RPG"
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (131, '{}', '{}');".format(q131, area_rpg_zc)
                        cur.execute(req_sql)
                    if cult_maj == '11,12,13,17,18,19':
                        if area_rpg_zc is None:
                            q132 = u"Q132 - pas surface enherbée"
                        else :
                            q132 = u"Q132 - superficie enherbées : " + str(area_rpg_zc)
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (132, '{}', '{}');".format(q132, area_rpg_zc)
                        cur.execute(req_sql)
                    if cult_maj == '1,2,3,4,5,6,7,8,9,10,14,15,16,20,21,22,23,24,25,26,27':
                        if area_rpg_zc is None:
                            q133 = u"Q133 - pas de surface cultivée"
                        else :
                            q133 = u"Q133 - superficie cultivées : " + str(area_rpg_zc)
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (133, '{}', '{}');".format(q133, area_rpg_zc)
                        cur.execute(req_sql)

        except :
            pass

        ###### Q15
        ### superficie du bati dans la zone contributive (zc_bati_total)

        try :
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_bati_total;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                sum_surface_bati = table[0]
                if sum_surface_bati is None :
                    q15 = u"Q15 - pas de surface baties dans la zone contributive"
                else :
                    q15 = u"Q15 - superficie totale des zones baties dans la zone contributive : " + str(sum_surface_bati)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (15, '{}', '{}');".format(q15,sum_surface_bati)
                cur.execute(req_sql)
        except :
            pass

        ####### Q16
        ### longueur totale des infras dans la zone contributive (zc_troncon_voie_ferre + zc_route_primaire + zc_route_secondaire)

        ### BD Topo < 3
        try :
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zc_{}_troncon_voie_ferree as a" \
                              " union select  sum(st_length(b.GEOM)) as sum from zc_{}_route_primaire as b" \
                              " union select  sum(st_length(c.GEOM)) as sum from zc_{}_route_secondaire as c )" \
                              " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                sum_lineaire_infra = table[0]
                if sum_lineaire_infra is None :
                    q16 = u"Q16 - pas d infrastructure dans la zone contributive : "
                else :
                    q16 = u"Q16 - longueur totale des infrastructures dans la zone contributive : " + str(sum_lineaire_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (16, '{}', '{}');".format(q16,sum_lineaire_infra)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3
        try :
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zc_{}_troncon_de_voie_ferree as a" \
                              " union select  sum(st_length(b.GEOM)) as sum from zc_{}_troncon_de_route as b )" \
                              " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                sum_lineaire_infra = table[0]
                if sum_lineaire_infra is None :
                    q16 = u"Q16 - pas d infrastructure dans la zone contributive : "
                else :
                    q16 = u"Q16 - longueur totale des infrastructures dans la zone contributive : " + str(sum_lineaire_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (16, '{}', '{}');".format(q16,sum_lineaire_infra)
                cur.execute(req_sql)
        except :
            pass

        ####### Q18
        ### superficie de la zone tampon

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from zt_{};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_zt = table[0]
            q18 = u"Q18 - superficie de la zone tampon : " + str(area_zt)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (18, '{}', '{}');".format(q18,area_zt)
            cur.execute(req_sql)

        ####### Q21
        ### superficie de la zone paysage

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from zp_{};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_zp = table[0]
            q21 = u"Q21 - superficie de la zone paysage : " + str(area_zp)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (21, '{}', '{}');".format(q21,area_zp)
            cur.execute(req_sql)

        ####### Q227_bis
        ### part des surfaces agricoles du rpg dans la zone paysage

        req_sql = "select round((sum(st_area(a.GEOM))/st_area(b.GEOMETRY)*100),3) from zp_{}_rpg as a , zp_{} as b;".format(nom_base, nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_surf_agri = table[0]
            if area_surf_agri is None :
                q227b = u"Q227_bis - pas de  I avec le rpg (surfaces agricoles dans la zone paysage)"
            else :
                q227b = u"Q227_bis - part I avec le rpg (surfaces agricoles dans la zone paysage) : " + str(area_surf_agri)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (2272, '{}','{}');".format(q227b,area_surf_agri)
            cur.execute(req_sql)

        ####### Q23 > Q24
        ### surface totale des corridors haies dans la zone paysage (zp_zone_vegetation)(attribut 'nature' = haie)

        ### BD Topo < 3

        try:
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zp_{}_zone_vegetation where nature = 'Haie';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                area_haie = table[0]
                if area_haie is None:
                    q24 = u"Q24 - superficie des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
                else:
                    q24 = u"Q24 - superficie des corridors boisés : " + str(area_haie)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (24, '{}', '{}');".format(q24,area_haie)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zp_{}_zone_de_vegetation where nature = 'Haie';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                area_haie = table[0]
                if area_haie is None:
                    q24 = u"Q24 - superficie des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
                else:
                    q24 = u"Q24 - superficie des corridors boisés : " + str(area_haie)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (24, '{}', '{}');".format(q24,area_haie)
                cur.execute(req_sql)
        except :
            pass

        ###### Q26
        ### linéaire des corridors boisées

        ####### Q271 Q272
        ### longueur des cours d'eaux permanents et longueur des cours d'eaux temporaires dans la zone paysage (zp_troncon_cours_eau) (attribut 'regime')

        ### BD Topo < 3

        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_cours_eau where regime = 'Intermittent';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_intermittent = table[0]
                if lineaire_intermittent is None :
                    q271 = u"Q271 - pas de cours d eau intermittents dans la zone paysage"
                else :
                    q271 = u"Q271 - longueur totale des cours d eau intermittents dans la zone paysage : " + str(lineaire_intermittent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (271, '{}', '{}');".format(q271,lineaire_intermittent)
                cur.execute(req_sql)

            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_cours_eau where regime = 'Permanent';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_permanent = table[0]
                if lineaire_permanent is None :
                    q272 = u"Q272 - pas de cours d eau permanents dans la zone paysage"
                else :
                    q272 = u"Q272 - longueur totale des cours d eau permanents dans la zone paysage : " + str(lineaire_permanent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (272, '{}', '{}');".format(q272,lineaire_permanent)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_hydrographique where persistanc = 'Intermittent';".format(
                nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_intermittent = table[0]
                if lineaire_intermittent is None:
                    q271 = u"Q271 - pas de cours d eau intermittents dans la zone paysage"
                else:
                    q271 = u"Q271 - longueur totale des cours d eau intermittents dans la zone paysage : " + str(
                        lineaire_intermittent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (271, '{}', '{}');".format(q271,
                                                                                                         lineaire_intermittent)
                cur.execute(req_sql)

            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_hydrographique where persistanc = 'Permanent';".format(
                nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_permanent = table[0]
                if lineaire_permanent is None:
                    q272 = u"Q272 - pas de cours d eau permanents dans la zone paysage"
                else:
                    q272 = u"Q272 - longueur totale des cours d eau permanents dans la zone paysage : " + str(
                        lineaire_permanent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (272, '{}', '{}');".format(q272,
                                                                                                         lineaire_permanent)
                cur.execute(req_sql)
        except:
            pass

        ####### Q29
        ### longueur des grandes infras dans la zone paysage (zp_troncoies_voie_ferree + zp_route primaire)

        ### BD Topo < 3

        try:
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zp_{}_troncon_voie_ferree as a" \
                      " union select  sum(st_length(b.GEOM)) as sum from zp_{}_route_primaire as b)" \
                      " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_gds_infra = table[0]
                if lineaire_gds_infra is None :
                    q29 = u"Q29 - pas de grande infrastructure dans la zone paysage "
                else :
                    q29 = u"Q29 - longueur totale des grandes infrastructures dans la zone paysage : " + str(lineaire_gds_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (29, '{}', '{}');".format(q29,lineaire_gds_infra)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zp_{}_troncon_de_voie_ferree as a " \
                      "union select  sum(st_length(b.GEOM)) as sum from zp_{}_troncon_de_route as b " \
                      "where importance in ('1','2')) " \
                      "select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_gds_infra = table[0]
                if lineaire_gds_infra is None:
                    q29 = u"Q29 - pas de grande infrastructure dans la zone paysage "
                else:
                    q29 = u"Q29 - longueur totale des grandes infrastructures dans la zone paysage : " + str(
                        lineaire_gds_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (29, '{}', '{}');".format(q29,
                                                                                                        lineaire_gds_infra)
                cur.execute(req_sql)
        except:
            pass

        ####### Q32
        ### longueur des petites infras dans la zone paysage (zp_route_secondaire)
        # route_secondaire

        ### BD Topo < 3
        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_route_secondaire;".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_pt_infra = table[0]
                if lineaire_pt_infra is None :
                    q32 = u"Q32 - pas de petite infrastructure dans la zone paysage"
                else :
                    q32 = u"Q32 - longueur totale des petites infrastructures dans la zone paysage : " + str(lineaire_pt_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (32, '{}', '{}');".format(q32,lineaire_pt_infra)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3
        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_de_route " \
                      "where importance not in ('1','2');".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_pt_infra = table[0]
                if lineaire_pt_infra is None :
                    q32 = u"Q32 - pas de petite infrastructure dans la zone paysage"
                else :
                    q32 = u"Q32 - longueur totale des petites infrastructures dans la zone paysage : " + str(lineaire_pt_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (32, '{}', '{}');".format(q32,lineaire_pt_infra)
                cur.execute(req_sql)
        except:
            pass


        ####### Q35
        ### presence de ligne electrique dans la zone paysage (zp_ligne_electrique)

        req_sql = "select count(ogc_fid) from zp_{}_ligne_electrique ;".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            nb_ligne_ht = table[0]
            if nb_ligne_ht == 0 :
                q35 = u"Q35 - pas de ligne électrique haute tension dans le paysage"
            else :
                q35 = u"Q35 - présence de ligne électrique haute tension dans le paysage"
            req_sql = "insert into resultats (id, reponse) VALUES (35, '{}');".format(q35)
            cur.execute(req_sql)

        ####### Q37
        ### presence de point de captage dans le paysage (zp_point_eau)

        ### BD Topo < 3

        try:
            req_sql = "select count(ogc_fid) from zp_{}_point_eau where nature = 'Source captée' or nature = 'Fontaine' or nature = 'Station de pompage';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                nb_pt_captage = table[0]
                if nb_pt_captage == 0 :
                    q37 = u"Q37 - pas de point de captage dans le paysage / ATTENTION : cela nécessite une confirmation de votre part avec les autres sources d informations mentionnées dans le guide "
                else :
                    q37 = u"Q37 - présence de point de captage dans le paysage"
                req_sql = "insert into resultats (id, reponse) VALUES (37, '{}');".format(q37)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "select count(ogc_fid) from zp_{}_detail_hydrographique;".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                nb_pt_captage = table[0]
                if nb_pt_captage == 0:
                    q37 = u"Q37 - pas de point de captage dans le paysage / ATTENTION : cela nécessite une confirmation de votre part avec les autres sources d informations mentionnées dans le guide "
                else:
                    q37 = u"Q37 - présence de point de captage dans le paysage"
                req_sql = "insert into resultats (id, reponse) VALUES (37, '{}');".format(q37)
                cur.execute(req_sql)
        except:
            pass

        ####### Q42
        ### distance la plus courte entre le centroide du site et le lit mineur (troncon_cours_eau)

        ### BD Topo < 3

        try:
            req_sql = "select round((min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOMETRY)), st_centroid(a.GEOMETRY)))/1000),3)" \
                      " from {} a, troncon_cours_eau b;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                distancepluscourte = table[0]
                q42 = u"Q42 - distance la plus courte entre le centre du site et le lit mineur du cours d eau : " + str(distancepluscourte) + u" / ATTENTION : calcul à prendre en compte uniquement si le site est alluvial"
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (42, '{}', '{}');".format(q42,distancepluscourte)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOMETRY)), st_centroid(a.GEOMETRY)))/1000),3)" \
                      " from {} a, troncon_hydrographique b;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                distancepluscourte = table[0]
                q42 = u"Q42 - distance la plus courte entre le centre du site et le lit mineur du cours d eau : " + str(
                    distancepluscourte) + u" / ATTENTION : calcul à prendre en compte uniquement si le site est alluvial"
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (42, '{}', '{}');".format(q42,
                                                                                                        distancepluscourte)
                cur.execute(req_sql)
        except:
            pass

        ####### Q43
        ### méandrage du cours d'eau

        ### creation du tampon de 1000 m à partir du point de la Q42

        # req_sql = "drop table if exists mnefzh.buffer_meandre; create table mnefzh.buffer_meandre as" \
        #           " with b as( with a as ( select st_distance(ST_ClosestPoint(b.geom, st_centroid(a.geom)), st_centroid(a.geom)) as distance, ST_ClosestPoint(b.geom, st_centroid(a.geom)) as geom, 1 as test" \
        #           " from mnefzh.mc_ecopole a, mnefzh.dep077_ed131_troncon_cours_eau b)" \
        #           " SELECT distance, geom,rank() OVER (PARTITION BY test ORDER BY distance asc) as rang  FROM a) " \
        #           " select distance, st_buffer(geom,1000) from b where rang = 1;"
        # cur.execute(req_sql)

        conn.commit()
        conn.close()

################### Affichage des resultats dans l interface ###################

        details = ''
        details += "<FONT face=""arial"" size=""2pt"">"+ q1
        details += "<br /> <br />" + q11
        try :
            if q131.find('ATTENTION') != -1 :
                details += "<br /> <br />" + q131.split('/')[0] +  "<FONT color=""red"">" + "/" + q131.split('/')[1] + "</FONT>"
            else :
                details += "<br /> <br />" + q131
            details += "<br /> <br />" + q132
            details += "<br /> <br />" + q133
            details += "<br /> <br />" + q15
            details += "<br /> <br />" + q16
        except :
            pass
        details += "<br /> <br />" + q18
        details += "<br /> <br />" + q21
        details += "<br /> <br />" + q227b

        if q24.find('ATTENTION') != -1 :
            details += "<br /> <br />" + q24.split('/')[0] +  "<FONT color=""red"">" + "/" + q24.split('/')[1] + "</FONT>"
        else :
            details += "<br /> <br />" + q24
        details += "<br /> <br />" + q271
        details += "<br /> <br />" + q272
        details += "<br /> <br />" + q29
        details += "<br /> <br />" + q32
        details += "<br /> <br />" + q35
        if q37.find('ATTENTION') != -1 :
            details += "<br /> <br />" + q37.split('/')[0] +  "<FONT color=""red"">" + "/" + q37.split('/')[1] + "</FONT>"
        else :
            details += "<br /> <br />" + q37

        if q42.find('ATTENTION') != -1 :
            details += "<br /> <br />" + q42.split('/')[0] +  "<FONT color=""red"">" + "/" + q42.split('/')[1] + "</FONT>"
        else :
            details += "<br /> <br />" + q42


        self.webView.setHtml(details)



