#' carto.RIP: Application shiny pour cartographier les risques d'impacts cumulés nationaux et régionaux
#' 
#' @description 
#' Cartographie nationale et régionale avec choix des paramètres (Réseau d'aires protégées, Pression, Milieux, Région), export des cartes
#' 
#' La construction et le lancement de l'application se fait grâce au fichier analyses->Rcode01_PrepRunShiny.R ; 
#' 
#' 
#' @author Marie-Caroline Prima \email{marie-caroline.prima@mnhn.fr}
#' 
#' @date 2022/12/02



## Installation des dépendances ----
renv::restore()


## Chargement des fonctions et packages ----
devtools::load_all(here::here())

## Run the application ----
library(shiny)
runApp(here::here("analyses", "Rcode01_PrepRunShiny.R"))
