# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh version 2
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2023-04-26
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""


from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import os.path, unicodedata



class boite :

   def boite_rouge(x, y, z):
      x.setStyleSheet('QToolButton {background-color: #FF0000}')
      y.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
      z.setStyleSheet('QLabel {color : #FF0000}')

   def boite_verte(x, y, z):
      x.setStyleSheet('QToolButton {background-color: #a5d50c}')
      y.setStyleSheet('QLineEdit {border: 2px solid #a5d50c}')
      z.setStyleSheet('QLabel {color : #a5d50c}')

   def message(self,texte,info):
      msg1 = QMessageBox()
      msg1.setIcon(QMessageBox.Warning)
      msg1.setText(texte)
      msg1.setInformativeText(info)
      msg1.setWindowTitle(u"Avertissement")
      return msg1

   def message_chemin(self):
      msg1 = QMessageBox()
      msg1.setIcon(QMessageBox.Warning)
      msg1.setText(u"Le chemin comporte des espaces ou des caractères spéciaux")
      msg1.setInformativeText(u"Modifiez le chemin avant de relancer")
      msg1.setWindowTitle(u"Avertissement")
      return msg1

   def controle_chemin(self,str_lineedit,toolbutton,lineedit,label):

      envoyeur = self.sender()
      lien = envoyeur.text()
      lien = unicode(lien)
      lien = unicodedata.normalize('NFKD', lien).encode('ascii', 'ignore')


      if envoyeur.objectName() == str_lineedit:
         if envoyeur.text() == "":
            boite.boite_rouge(toolbutton, lineedit, label)
         if envoyeur.text() != "":
            boite.boite_verte(toolbutton, lineedit, label)

            #### Verification de l'existence d'accent ou d'espace dans le lien ####
            if os.path.exists(lien) == False or envoyeur.text().find(' ') != -1:
               boite.boite_rouge(toolbutton, lineedit, label)
               boite.message_chemin(self).exec_()
               lineedit.clear()