# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mnefzh version 2
                                 A QGIS plugin
 Méthode nationale d'évaluation des fonctionnalités des zones humides
                              -------------------
        begin                : 2023-04-26
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sqlite3

from .boite import boite


class afficherquestions():

    def select_dossier_base_2(self):
        base_2,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .sqlite de la base souhaitée", '*.sqlite')
        self.lineEdit_base_2.setText(base_2)


    def affiche_questions(self):

        self.webView.history().clear()

        #### definition des variables ####
        dossier_base_2 = self.lineEdit_base_2.text()
        nom_base = (dossier_base_2.split('/')[-1]).split('.')[0]

        #### Verification du remplissage des champs #######

        if dossier_base_2 == '':
            boite.boite_rouge(self.toolButton_base_2, self.lineEdit_base_2, self.label_base_2)
            boite.message(self,u"Vous n'avez pas renseigné d'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        #### connexion a la base selectionnee ####

        conn = sqlite3.dbapi2.connect(dossier_base_2)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")

        #### creation de la table des resulats ####

        req_sql = "drop table if exists resultats;"
        cur.execute(req_sql)
        req_sql = "create table resultats (id INT PRIMARY KEY NOT NULL,reponse TEXT, valeur INT4);"
        cur.execute(req_sql)


        ################### Response aux questions  ###################

        ####### Q1
        ### superficie du site

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from {};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        print(tables)
        for table in tables:
            area_site = table[0]
            q1 = u"- superficie du site : " + str(area_site)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (1, '{}', '{}');".format(q1,area_site)
            cur.execute(req_sql)

        ####### Q2
        ### Si le site de compensation est constitué de polygones disjoints,
        # quelle est la superficie moyenne de ces polygones ? Sinon, passez à la question suivante sans répondre à celle-ci.

        try :
            req_sql = "select count(gid) from {}_singlepoly".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                print(table)
                print(table[0])
                nb_polygone = int(table[0])
                print(nb_polygone)
                if nb_polygone > 1 :
                    req_sql = "select round((avg(st_area(GEOMETRY))/10000),3) from {}_singlepoly;".format(nom_base)
                    cur.execute(req_sql)
                    tables = cur.fetchall()
                    for table in tables:
                        area_site_disjoint = table[0]

                    q2 = u"- superficie moyenne des différents polygones du site : " + str(area_site_disjoint)
                    req_sql = "insert into resultats (id, reponse, valeur) VALUES (2, '{}', '{}');".format(q2,area_site_disjoint)
                    cur.execute(req_sql)
                else :
                    multi_polgone = "NO"
                    pass
        except :
            pass

        ####### Q12
        ### superficie et périmètre de la zone contributive (zc)
        try :
            req_sql = "select round((st_area(GEOMETRY)/10000),3) from zc_{};".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                area_zc = table[0]
                q12 = u"- superficie de la zone contributive : " + str(area_zc)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (12, '{}', '{}');".format(q12, area_zc)
                cur.execute(req_sql)

            req_sql = "select round((st_perimeter(GEOMETRY)/1000),3) from zc_{};".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                perimetre_zc = table[0]
                q121 = u"- périmètre de la zone contributive : " + str(perimetre_zc)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (121, '{}', '{}');".format(q121, perimetre_zc)
                cur.execute(req_sql)

        except:
            q12 = u"- pas de zone contributive renseignée"
            pass

            ###### Q13
            ### superficie des surfaces divers, des surfaces enherbees et des surfaces cultivees dans la zone contributive (zc_rpg)

        try :
            liste_cult_maj = ['28','11,12,13,17,18,19','1,2,3,4,5,6,7,8,9,10,14,15,16,20,21,22,23,24,25,26,27']
            for cult_maj in liste_cult_maj :

                try :
                    req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_rpg where cult_maj in ({});".format(nom_base, cult_maj)
                    cur.execute(req_sql)
                except BaseException:
                    req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_rpg where code_group in ({});".format(nom_base, cult_maj)
                    cur.execute(req_sql)
                    pass

                tables = cur.fetchall()
                for table in tables:
                    area_rpg_zc = table[0]
                    if cult_maj == '28':
                        if area_rpg_zc is None:
                            q131 = u"- superficie divers : aucune superficie divers "
                        else :
                            q131 = u"- superficie divers : " + str(area_rpg_zc) + u" / ATTENTION :  réaliser une photo-interprétation pour réaffecter ce divers si vous le jugez indispensable ; ce type d assolement n est pas renseigné dans le RPG"
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (131, '{}', '{}');".format(q131, area_rpg_zc)
                        cur.execute(req_sql)
                    if cult_maj == '11,12,13,17,18,19':
                        if area_rpg_zc is None:
                            q132 = u"- pas surface enherbée"
                        else :
                            q132 = u"- surfaces enherbées : " + str(area_rpg_zc)
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (132, '{}', '{}');".format(q132, area_rpg_zc)
                        cur.execute(req_sql)
                    if cult_maj == '1,2,3,4,5,6,7,8,9,10,14,15,16,20,21,22,23,24,25,26,27':
                        if area_rpg_zc is None:
                            q133 = u"- pas de surface cultivée"
                        else :
                            q133 = u"- surfaces cultivées : " + str(area_rpg_zc)
                        req_sql = "insert into resultats (id, reponse, valeur) VALUES (133, '{}', '{}');".format(q133, area_rpg_zc)
                        cur.execute(req_sql)

        except :
            q131 = u"- pas de zone contributive renseignée"
            pass

        #### superficie construites
        try :
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zc_{}_bati_total;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                sum_surface_bati = table[0]
                if sum_surface_bati is None :
                    q134 = u"- pas de surface construite"
                else :
                    q134 = u"- surfaces construites : " + str(sum_surface_bati)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (134, '{}', '{}');".format(q134,sum_surface_bati)
                cur.execute(req_sql)
        except :
            pass

        ####### lineaire des infrastructures de transport
        ### longueur totale des infras dans la zone contributive (zc_troncon_voie_ferre + zc_route_primaire + zc_route_secondaire)

        ### BD Topo < 3
        try :
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zc_{}_troncon_voie_ferree as a" \
                      " union select  sum(st_length(b.GEOM)) as sum from zc_{}_route_primaire as b" \
                      " union select  sum(st_length(c.GEOM)) as sum from zc_{}_route_secondaire as c )" \
                      " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                sum_lineaire_infra = table[0]
                if sum_lineaire_infra is None :
                    q135 = u"- pas d infrastructure dans la zone contributive : "
                else :
                    q135 = u"- linéraire d'infrastructures de transport : " + str(sum_lineaire_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (135, '{}', '{}');".format(q135,sum_lineaire_infra)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3
        try :
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zc_{}_troncon_de_voie_ferree as a" \
                      " union select  sum(st_length(b.GEOM)) as sum from zc_{}_troncon_de_route as b )" \
                      " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                sum_lineaire_infra = table[0]
                if sum_lineaire_infra is None :
                    q135 = u"- pas d infrastructure dans la zone contributive : "
                else :
                    q135 = u"- linéraire d'infrastructures de transport : " + str(sum_lineaire_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (135, '{}', '{}');".format(q135,sum_lineaire_infra)
                cur.execute(req_sql)
        except :
            pass



        #### linéaire des cours d'eau
        try :
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zc_{}_troncon_hydrographique;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                sum_lineaire_hydro = table[0]
                if sum_lineaire_hydro is None :
                    q136 = u"- pas de cours d'eau"
                else :
                    q136 = u"- linéaire de cours d'eau : " + str(sum_lineaire_hydro)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (136, '{}', '{}');".format(q136,sum_lineaire_hydro)
                cur.execute(req_sql)
        except :
            pass





        ####### Q14
        ### superficie de la zone tampon

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from zt_{};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_zt = table[0]
            q14 = u"- superficie de la zone tampon : " + str(area_zt)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (14, '{}', '{}');".format(q14,area_zt)
            cur.execute(req_sql)

        ####### Q16
        ### superficie de la zone paysage

        req_sql = "select round((st_area(GEOMETRY)/10000),3) from zp_{};".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            area_zp = table[0]
            q16 = u"- superficie du paysage : " + str(area_zp)
            req_sql = "insert into resultats (id, reponse, valeur) VALUES (16, '{}', '{}');".format(q16,area_zp)
            cur.execute(req_sql)



        ####### Q18
        ### surface totale des corridors haies dans la zone paysage (zp_zone_vegetation)(attribut 'nature' = haie)

        ### BD Topo < 3

        try:
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zp_{}_zone_vegetation where nature = 'Haie';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                area_haie = table[0]
                if area_haie is None:
                    q18 = u"- superficie des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
                else:
                    q18 = u"- superficie des corridors boisés : " + str(area_haie)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (18, '{}', '{}');".format(q18,area_haie)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((sum(st_area(GEOM))/10000),3) from zp_{}_zone_de_vegetation where nature = 'Haie';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                area_haie = table[0]
                if area_haie is None:
                    q18 = u"- superficie des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
                else:
                    q18 = u"- superficie des corridors boisés : " + str(area_haie)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (18, '{}', '{}');".format(q18,area_haie)
                cur.execute(req_sql)
        except :
            pass

            # ### linéaire totale des corridors haies dans la zone paysage (zp_zone_vegetation)(attribut 'nature' = haie)
            #
            # ### BD Topo < 3
            #
            # try:
            #     req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_zone_vegetation where nature = 'Haie';".format(
            #         nom_base)
            #     cur.execute(req_sql)
            #     tables = cur.fetchall()
            #     for table in tables:
            #         lineaire_haie = table[0]
            #         if lineaire_haie is None:
            #             q181 = u"- linéaire des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
            #         else:
            #             q181 = u"- linéaire des corridors boisés : " + str(lineaire_haie)
            #         req_sql = "insert into resultats (id, reponse, valeur) VALUES (181, '{}', '{}');".format(q181,
            #                                                                                                 lineaire_haie)
            #         cur.execute(req_sql)
            # except:
            #     pass
            #
            # ### BD Topo > 3
            #
            # try:
            #     req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_zone_de_vegetation where nature = 'Haie';".format(
            #         nom_base)
            #     cur.execute(req_sql)
            #     tables = cur.fetchall()
            #     for table in tables:
            #         lineaire_haie = table[0]
            #         if lineaire_haie is None:
            #             q181 = u"- linéaire des corridors boisés / ATTENTION : pas de HAIE identifiée ans la BD TOPO(r) ; une photo-interpretation doit être effectuée"
            #         else:
            #             q181 = u"- linéaire des corridors boisés : " + str(lineaire_haie)
            #         req_sql = "insert into resultats (id, reponse, valeur) VALUES (181, '{}', '{}');".format(q181,
            #                                                                                                 lineaire_haie)
            #         cur.execute(req_sql)
            # except:
            #     pass



        ####### Q19
        ### longueur des cours d'eaux permanents et longueur des cours d'eaux temporaires dans la zone paysage (zp_troncon_cours_eau) (attribut 'regime')

        ### BD Topo < 3

        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_cours_eau where regime = 'Intermittent';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_intermittent = table[0]
                if lineaire_intermittent is None :
                    q19 = u"- pas de corridors aquatiques temporaires"
                else :
                    q19 = u"- Corridors aquatiques temporaires : " + str(lineaire_intermittent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (19, '{}', '{}');".format(q19,lineaire_intermittent)
                cur.execute(req_sql)

            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_cours_eau where regime = 'Permanent';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_permanent = table[0]
                if lineaire_permanent is None :
                    q19 = u"- pas de corridors aquatiques permanents"
                else :
                    q19 = u"- Corridors aquatiques permanents : " + str(lineaire_permanent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (19, '{}', '{}');".format(q19,lineaire_permanent)
                cur.execute(req_sql)
        except :
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_hydrographique where persistanc = 'Intermittent';".format(
                nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_intermittent = table[0]
                if lineaire_intermittent is None:
                    q19 = u"- pas de corridors aquatiques temporaires"
                else:
                    q19 = u"-  Corridors aquatiques temporaires : " + str(
                        lineaire_intermittent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (19, '{}', '{}');".format(q19,
                                                                                                         lineaire_intermittent)
                cur.execute(req_sql)

            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_hydrographique where persistanc = 'Permanent';".format(
                nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_permanent = table[0]
                if lineaire_permanent is None:
                    q191 = u"- pas de corridors aquatiques permanents"
                else:
                    q191 = u"- Corridors aquatiques permanents : " + str(
                        lineaire_permanent)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (191, '{}', '{}');".format(q191,
                                                                                                         lineaire_permanent)
                cur.execute(req_sql)
        except:
            pass


        ### longueur des grandes infras dans la zone paysage (zp_troncoies_voie_ferree + zp_route primaire)

        ### BD Topo < 3

        try:
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zp_{}_troncon_voie_ferree as a" \
                      " union select  sum(st_length(b.GEOM)) as sum from zp_{}_route_primaire as b)" \
                      " select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_gds_infra = table[0]
                if lineaire_gds_infra is None :
                    q192 = u"- pas de grande infrastructure de transport"
                else :
                    q192 = u"- Grandes infrastructures de transport : " + str(lineaire_gds_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (192, '{}', '{}');".format(q192,lineaire_gds_infra)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "with a as ( select sum(st_length(a.GEOM)) as sum from zp_{}_troncon_de_voie_ferree as a " \
                      "union select  sum(st_length(b.GEOM)) as sum from zp_{}_troncon_de_route as b " \
                      "where importance in ('1','2')) " \
                      "select round((sum(sum)/1000),3) from a".format(nom_base, nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_gds_infra = table[0]
                if lineaire_gds_infra is None:
                    q192 = u"- pas de grande infrastructure de transport"
                else:
                    q192 = u"- Grandes infrastructures de transport : " + str(
                        lineaire_gds_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (192, '{}', '{}');".format(q192,
                                                                                                        lineaire_gds_infra)
                cur.execute(req_sql)
        except:
            pass

        ### longueur des petites infras dans la zone paysage (zp_route_secondaire)
        # route_secondaire

        ### BD Topo < 3
        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_route_secondaire;".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_pt_infra = table[0]
                if lineaire_pt_infra is None :
                    q193 = u"- pas de petite infrastructure de transport"
                else :
                    q193 = u"- Petites infrastructures de transport : " + str(lineaire_pt_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (193, '{}', '{}');".format(q193,lineaire_pt_infra)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3
        try:
            req_sql = "select round((sum(st_length(GEOM))/1000),3) from zp_{}_troncon_de_route " \
                      "where importance not in ('1','2');".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                lineaire_pt_infra = table[0]
                if lineaire_pt_infra is None :
                    q193 = u"- pas de petite infrastructure de transport"
                else :
                    q193 = u"- Petites infrastructures de transport : " + str(lineaire_pt_infra)
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (193, '{}', '{}');".format(q193,lineaire_pt_infra)
                cur.execute(req_sql)
        except:
            pass


        ####### Q20
        ### presence de ligne electrique dans la zone paysage (zp_ligne_electrique)

        req_sql = "select count(pk) from zp_{}_ligne_electrique ;".format(nom_base)
        cur.execute(req_sql)
        tables = cur.fetchall()
        for table in tables:
            nb_ligne_ht = table[0]
            if nb_ligne_ht == 0 :
                q20 = u"- pas de ligne électrique haute tension"
            else :
                q20 = u"- présence de ligne électrique haute tension"
            req_sql = "insert into resultats (id, reponse) VALUES (20, '{}');".format(q20)
            cur.execute(req_sql)

        ### presence de point de captage dans le paysage (zp_point_eau)

        ### BD Topo < 3

        try:
            req_sql = "select count(pk) from zp_{}_point_eau where nature = 'Source captée' or nature = 'Fontaine' or nature = 'Station de pompage';".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                nb_pt_captage = table[0]
                if nb_pt_captage == 0 :
                    q201 = u"- pas de point de captage / ATTENTION : cela nécessite une confirmation de votre part avec les autres sources d informations mentionnées dans le guide "
                else :
                    q201 = u"- présence de point de captage"
                req_sql = "insert into resultats (id, reponse) VALUES (201, '{}');".format(q201)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "select count(pk) from zp_{}_detail_hydrographique;".format(nom_base)
            cur.execute(req_sql)
            tables = cur.fetchall()
            for table in tables:
                nb_pt_captage = table[0]
                if nb_pt_captage == 0:
                    q201 = u"- pas de point de captage dans le paysage / ATTENTION : cela nécessite une confirmation de votre part avec les autres sources d informations mentionnées dans le guide "
                else:
                    q201 = u"- présence de point de captage dans le paysage"
                req_sql = "insert into resultats (id, reponse) VALUES (201, '{}');".format(q201)
                cur.execute(req_sql)
        except:
            pass

        ####### Q34
        ### distance la plus courte entre le centroide du site et le lit mineur (troncon_cours_eau)

        ### BD Topo < 3

        try:
            req_sql = "select round((min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOMETRY)), st_centroid(a.GEOMETRY)))/1000),3)" \
                      " from {} a, troncon_cours_eau b;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                distancepluscourte = table[0]
                q34 = u"Q34 - distance la plus courte entre le centre du site et le lit mineur du cours d eau : " + str(distancepluscourte) + u" / ATTENTION : calcul à prendre en compte uniquement si le site est alluvial"
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (34, '{}', '{}');".format(q34,distancepluscourte)
                cur.execute(req_sql)
        except:
            pass

        ### BD Topo > 3

        try:
            req_sql = "select round((min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOMETRY)), st_centroid(a.GEOMETRY)))/1000),3)" \
                      " from {} a, troncon_hydrographique b;".format(nom_base)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                distancepluscourte = table[0]
                q34 = u"Q34 - distance la plus courte entre le centre du site et le lit mineur du cours d eau : " + str(
                    distancepluscourte) + u" / ATTENTION : calcul à prendre en compte uniquement si le site est alluvial"
                req_sql = "insert into resultats (id, reponse, valeur) VALUES (34, '{}', '{}');".format(q34,
                                                                                                        distancepluscourte)
                cur.execute(req_sql)
        except:
            pass



        ####### Q43
        ### méandrage du cours d'eau

        ### creation du tampon de 1000 m à partir du point de la Q42

        # req_sql = "drop table if exists mnefzh.buffer_meandre; create table mnefzh.buffer_meandre as" \
        #           " with b as( with a as ( select st_distance(ST_ClosestPoint(b.geom, st_centroid(a.geom)), st_centroid(a.geom)) as distance, ST_ClosestPoint(b.geom, st_centroid(a.geom)) as geom, 1 as test" \
        #           " from mnefzh.mc_ecopole a, mnefzh.dep077_ed131_troncon_cours_eau b)" \
        #           " SELECT distance, geom,rank() OVER (PARTITION BY test ORDER BY distance asc) as rang  FROM a) " \
        #           " select distance, st_buffer(geom,1000) from b where rang = 1;"
        # cur.execute(req_sql)

        conn.commit()
        conn.close()

        ################### Affichage des resultats dans l interface ###################

        details = ''
        details += "<FONT face=""arial"" size=""2pt""> Question 1 - Quelle est la superficie du site ? <br />"
        details += q1
        try :
            details += "<br /> <br />"
            details += "<FONT face=""arial"" size=""2pt""> Question 2 - Si le site est constitué de polygones disjoints, quelle la superficie moyenne de ces polygones ? <br />"
            details += q2
        except :
            pass

        try:
            details += "<br /> <br />"
            details += "<FONT face=""arial"" size=""2pt""> Question 12 – Quels sont la superficie et le périmètre de la zone contributive ? <br />"
            details += q12
            details += "<br />" + q121
        except :
            pass

        try :
            details += "<br /> <br />"
            details += "<FONT face=""arial"" size=""2pt""> Question 13 – Quelle est l’occupation du sol dans la zone contributive ? <br />"
            if q131.find('ATTENTION') != -1 :
                details += q131.split('/')[0] +  "<FONT color=""red"">" + "/" + q131.split('/')[1] + "</FONT>"
            else :
                details += q131
            details += "<br />" + q132
            details += "<br />" + q133
            details += "<br />" + q134
            details += "<br />" + q135
            details += "<br />" + q136
        except :
            pass

        details += "<br /> <br />"
        details += "<FONT face=""arial"" size=""2pt""> Question 14 - Quelle est la zone tampon du site ? <br />"
        details += q14
        details += "<br /> <br />"
        details += "<FONT face=""arial"" size=""2pt""> Question 16 - Quelle est la superficie du paysage ? <br />"
        details += q16
        details += "<br /> <br />"
        details += "<FONT face=""arial"" size=""2pt""> Question 18 – Quelle est la superficie ou quel est le linéaire de corridors boisés dans le paysage ? <br />"
        if q18.find('ATTENTION') != -1 :
            details += q18.split('/')[0] +  "<FONT color=""red"">" + "/" + q18.split('/')[1] + "</FONT>"
            ##details += "<br />" + q181
        else :
            details += q18
            ##details += "<br />" + q181

        details += "<br /> <br />"
        details += "<FONT face=""arial"" size=""2pt""> Question 19 - Quel est le linéaire de corridors aquatiques et d’infrastructures dans le paysage ? <br />"
        details += q19
        details += "<br />" + q191
        details += "<br />" + q192
        details += "<br />" + q193

        details += "<br /> <br />"
        details += "<FONT face=""arial"" size=""2pt""> Question 20* - Une ligne à haute tension, un puits de captage (par ex : alimentation en eau potable, irrigation) sont-ils présents dans le paysage ? <br />"

        details += q20
        if q201.find('ATTENTION') != -1 :
            details += "<br /> " + q201.split('/')[0] +  "<FONT color=""red"">" + "/" + q201.split('/')[1] + "</FONT>"
        else :
            details += "<br /> " + q201



        if q34.find('ATTENTION') != -1 :
            details += "<br /> <br />" + q34.split('/')[0] +  "<FONT color=""red"">" + "/" + q34.split('/')[1] + "</FONT>"
        else :
            details += "<br /> <br />" + q34

        details = details.replace('.',',')

        self.webView.setHtml(details)




